#if !defined(AFX_SCRIPTENGINE_H__6CA5B122_1609_11D2_852F_F26A3B000000__INCLUDED_)
#define AFX_SCRIPTENGINE_H__6CA5B122_1609_11D2_852F_F26A3B000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// ScriptEngine.h : header file
//
//#include <afxcoll.h>
#include <afxtempl.h>

#include "scriptdoc.h"
 
#define kCommObjectName TEXT("Comm")

/* Token types */
typedef enum
{
	kTTEOF = 0,
	kTTIdentifier,
	kTTOperator,
	kTTString
} TokenKind;

typedef enum
{
	kDProcedure,
	kDFunction
} DeclKind;

/* Argument Types */
typedef enum
{
	kArgNone,
	kArgByte,
	kArgDate,
	kArgBoolean,
	kArgInteger,
	kArgLong,
	kArgSingle,
	kArgDouble,
	kArgString,
	kArgUString,
	kArgObject,
	kArgVariant
} ArgType;

typedef struct arg
{
	struct arg *next;
	bool byRef;
	bool array;
	ArgType argType;
} Argument;

typedef enum
{
	kFunction,
	kVariable,
	kObject,
	kPseudoVar,
	kDLLFunc
} BindingType;

/*
	Binding node
*/
typedef struct bindingnode
{
	struct bindingnode *next;		// Next in list
	DISPID ID;						// ID of symbol
	BindingType type;				// Type of this binding
	union
	{
		struct
		{
			ArgType retType;
			Argument *args;
		} DLLfunc;
		// VARIANT var;
		// NSBObject *obj;
	};
} BindingNode;

/*
	Symbol table node 
*/
typedef struct symbolnode
{
	struct symbolnode *left;
	struct symbolnode *right;
	DISPID ID;
	BSTR name;
} SymbolNode;


class CDictionary: IUnknown
{
public:
	CDictionary();
	~CDictionary();

	virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void** ppvObj);
	virtual ULONG STDMETHODCALLTYPE AddRef();
	virtual ULONG STDMETHODCALLTYPE Release();

	DISPID findName(LPCTSTR s, bool add);
	DISPID findNameHelper(LPCTSTR name, bool create, SymbolNode **nodeP);
	LPCTSTR getSymbolName(DISPID ID);
	/**
		Define a DLL function or procedure.  Fails if it's already there
		@param name The name of the function or procedure
		@param retArg The return value if it's a function
		@param args The arguments of the procedure or function
	  */
	bool defDLL(LPCTSTR name, ArgType retArg, Argument *args);
	void freeBindings(void);
	BindingNode *CDictionary::findDLL(DISPID dispIdMember);

	class Dispatch: IDispatch
	{
	public:
		CDictionary *parent;
		virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void** ppvObj);
		virtual ULONG STDMETHODCALLTYPE AddRef();
		virtual ULONG STDMETHODCALLTYPE Release();
		virtual HRESULT STDMETHODCALLTYPE GetTypeInfoCount(unsigned int FAR*  pctinfo);
		virtual HRESULT STDMETHODCALLTYPE GetTypeInfo(unsigned int iTInfo, LCID  lcid, ITypeInfo FAR* FAR*  ppTInfo);  
		virtual HRESULT STDMETHODCALLTYPE GetIDsOfNames(REFIID  riid, OLECHAR FAR* FAR*  rgszNames, unsigned int cNames, LCID lcid, DISPID FAR* rgDispId);    
		virtual HRESULT STDMETHODCALLTYPE Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr);

	} dispatch;


private:
	CMap< CString, LPCTSTR, DISPID, DISPID& > identifiers;
	BindingNode *bindings;
	SymbolNode *symbolsAsTree;	// The symbols as a binary tree
	SymbolNode **symbolsAsArray;	// The symbols as a dynamic array
	int allocedSymbols;			// The allocated symbols
	DISPID nextID;				// ID of next symbol
	long ref;
};

class CLibraryDispatch: public IDispatch
{
public:
	virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, void** ppvObj);
	virtual ULONG STDMETHODCALLTYPE AddRef();
	virtual ULONG STDMETHODCALLTYPE Release();
	virtual HRESULT STDMETHODCALLTYPE GetTypeInfoCount(unsigned int FAR*  pctinfo);
	virtual HRESULT STDMETHODCALLTYPE GetTypeInfo(unsigned int iTInfo, LCID  lcid, ITypeInfo FAR* FAR*  ppTInfo);  
	virtual HRESULT STDMETHODCALLTYPE GetIDsOfNames(REFIID  riid, OLECHAR FAR* FAR*  rgszNames, unsigned int cNames, LCID lcid, DISPID FAR* rgDispId);    
	virtual HRESULT STDMETHODCALLTYPE Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr);

	BSTR Declare(BSTR syntax, DeclKind kind, BSTR name);
	void nextToken(void);
	void skipblanks(void);
	BSTR declaration(DeclKind kind, BSTR name);
	ArgType type(void);

	CDictionary *GetDictionary(void);

	HRESULT doInvocation(DISPID dispIDMember, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr);
	HRESULT doDLL(BindingNode *node, DISPID dispIDMember, DISPPARAMS FAR*  pDispParams, VARIANT FAR* pVarResult, EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr);
	
	CLibraryDispatch(HINSTANCE library);
	~CLibraryDispatch(void);
	ULONG magicNumber;
protected:
	ULONG m_ref;
	HINSTANCE library;
	wchar_t *s;
	TokenKind tokenType;
	int token;
	CDictionary *dictionary;
};

extern "C"
{
	/**
		Call a dll function returning an int (or void, just ignore it)
		@param func The address of the function
		@param nArgs The number of 32-bit args
		@param args The args
	  */
	int callInt(void *func, int nArgs, int *args);
	
	/**
		Call a dll function returning a float
		@param func The address of the function
		@param nArgs The number of 32-bit args
		@param args The args
	  */
	float callFloat(void *func, int nArgs, int *args);

	/**
		Call a dll function returning a double
		@param func The address of the function
		@param nArgs The number of 32-bit args
		@param args The args
	  */
	double callDouble(void *func, int nArgs, int *args);

	/**
		Call a dll function returning a varuabt
		@param func The address of the function
		@param nArgs The number of 32-bit args
		@param args The args
	  */
	VARIANT callVariant(void *addr, int nArgs, int *args);
}

class CScriptObject
{
	public: 
		CWnd		*pCWnd;
		//HWND		hWnd;
		CString		cstrLabel;
		IUnknown	*pUnk;
		DWORD		dwFlags;

	public:
		CScriptObject(); 
		~CScriptObject() ;
};

typedef enum
{
	IntrinsicButton=0,
	IntrinsicEdit=1,
	IntrinsicCheck,
	IntrinsicRadio,
	IntrinsicList,
	IntrinsicCombo,
	IntrinsicStatic,
	IntrinsicDate,
	IntrinsicTime,
	IntrinsicFrame,
	IntrinsicTriButton,
	IntrinsicHScrollBar,
	IntrinsicVScrollBar,
	IntrinsicFocusRect,
	IntrinsicSpinBox
} IntrinsicControlType;

typedef struct tagIntrinsicObject
{
		IntrinsicControlType ictType;
		TCHAR	*	szShortName;	//the name to use from VBScript
		TCHAR	*	szClass;		//the Windows class name
		DWORD		dwStyle;
		DWORD		dwExStyle;
} IntrinsicObject;





#define OBJ_ISSOURCE 0x1
#define OBJ_ISACTIVEX 0x2
#define OBJ_ISWINDOW 0x4
#define OBJ_ISINTRINSIC 0x8
#define OBJ_ACTIVEXCONTROL OBJ_ISSOURCE|OBJ_ISACTIVEX|OBJ_ISWINDOW
#define OBJ_INTRINSICCONTROL OBJ_ISSOURCE|OBJ_ISWINDOW|OBJ_ISINTRINSIC


class CIntrinsicControl;

/////////////////////////////////////////////////////////////////////////////
// CScriptEngine command target

typedef class CScriptEngine : public CCmdTarget
	//public CComObjectRootEx<CComSingleThreadModel>,
	//public CComCoClass<CSimpleSite, &CLSID_SimpleSite>,
	//public IDispatchImpl<ISimpleSite, &IID_ISimpleSite, &LIBID_SCRIPTSITELib>,
	//public IActiveScriptSiteImpl,
	//public IActiveScriptSiteWindowImpl
{
	DECLARE_DYNCREATE(CScriptEngine)

public:
	CScriptEngine();           // protected constructor used by dynamic creation
	virtual ~CScriptEngine();
// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CScriptEngine)
	public:
	virtual void OnFinalRelease();
	//}}AFX_VIRTUAL

// Implementation
public:
	HWND					m_hWnd; 
	CWnd				*   m_pcWnd;
	CString					m_scriptpreamble;
	CScriptDoc			*   m_pCurrentDocument;
	CString				*   m_pcstrDebugScript;
	BOOL					m_bQueryUnloadCancel;
	
	BOOLEAN InitScriptEngine();
	void RunScript( LPCTSTR csScript, BOOLEAN bInitEnvironment, VARIANT *pVarResult = NULL, CScriptDoc *pDoc = NULL );
	BOOLEAN AddScriptObject(LPCTSTR szName,CWnd *pCWnd,HWND hWnd,IUnknown *pUnk,DWORD dwFlags=0);
	BOOLEAN AddScriptLibrary(LPCTSTR szName, HINSTANCE library, DWORD dwFlags=0);
	SendScriptMessage(const TCHAR *szMember, VARTYPE vtRet,  void *pvarResult, const BYTE FAR* pbParamInfo, ... );
	void ParseProps(CWnd *pCWnd, BSTR props, IDispatch *pDisp);
	DISPID ParseID(CWnd *pCWnd, IDispatch *pDisp);
	void ParseExpression(VARIANT *v);
	void ParseAssignment(CWnd *pCWnd, IDispatch *pDisp);

	void SkipBlanks(void);
	void NextToken(void);

	HRESULT ReleaseScriptEngine();
	void ListObjects(void);

	/* Look up an object by name */
	bool LookupObject(wchar_t *name, CScriptObject &obj);

	/* Look up an object by name */
	bool LookupObject(CString &name, CScriptObject &obj);

	/* Look up an object by CWnd */
	bool LookupObject(CWnd *wnd, CScriptObject&obj);

	/* Look up an object by HWND */
	bool LookupObject(HWND wnd, CScriptObject&obj);

	LPUNKNOWN AddObjectHelper(const CString &cstrName, const CString &cstrCaption, const CString &cstrParent,
							  LPUNKNOWN lpUnknownP,
							  BSTR type, BSTR license, BSTR props,
							  int iTop, int iLeft, int iWidth, int iHeight,
							  CIntrinsicControl **);


protected:

	CMap< CString, LPCTSTR, CScriptObject, CScriptObject& > m_objects;

	// ActiveX Scripting variables
	IActiveScript*			m_pScript;
	IActiveScriptParse*		m_pParse;
	COleDispatchDriver		m_ddScript;


	CMapStringToString		m_GuidLookup;
	CMapStringToPtr			m_IntrinsicLookup;

	// ActiveX Scripting functions
	HRESULT CreateScriptEngine();
	void InternalAddMenuItem(CWnd *pWnd, CMenu *pMenu, LPCTSTR szElem);


	DECLARE_OLETYPELIB(CScriptEngine)

	// Generated message map functions
	//{{AFX_MSG(CScriptEngine)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CScriptEngine)
	afx_msg BOOL GetKeyPreview();
	afx_msg void SetKeyPreview(BOOL bNewValue);
	afx_msg BOOL GetKeyboardStatus();
	afx_msg void SetKeyboardStatus(BOOL bNewValue);
	afx_msg BSTR GetCurrentPath();
	afx_msg void SetCurrentPath(LPCTSTR lpszNewValue);
	afx_msg BSTR GetTitle();
	afx_msg void SetTitle(LPCTSTR lpszNewValue);
	afx_msg BSTR GetNSBVersion();
	afx_msg void SetNSBVersion(LPCTSTR lpszNewValue);
	afx_msg long GetLastHWND();
	afx_msg BSTR xGetCommandLine();
	afx_msg long GetWaveVolume();
	afx_msg void SetWaveVolume(long nNewValue);
	afx_msg long GetAppHWnd();
	afx_msg BOOL GetQueryUnloadCancel();
	afx_msg void SetQueryUnloadCancel(BOOL bNewValue);
	afx_msg BOOL AddControl(LPCTSTR Class, LPCTSTR Name, short Left, short Top, short Wdth, short Height);
	afx_msg void execute(LPCTSTR szScript);
	afx_msg VARIANT eval(LPCTSTR szExpression);
	afx_msg void print(const VARIANT FAR& text1,const VARIANT FAR& text2,const VARIANT FAR& text3,const VARIANT FAR& text4,const VARIANT FAR& text5,const VARIANT FAR& text6,const VARIANT FAR& text7,const VARIANT FAR& text8,const VARIANT FAR& text9,const VARIANT FAR& text10,const VARIANT FAR& text11,const VARIANT FAR& text12,const VARIANT FAR& text13,const VARIANT FAR& text14,const VARIANT FAR& text15,const VARIANT FAR& text16,const VARIANT FAR& text17,const VARIANT FAR& text18,const VARIANT FAR& text19,const VARIANT FAR& text20);
	afx_msg long MsgBox(const VARIANT FAR& prompt,const VARIANT FAR& buttons,const VARIANT FAR& title);
	afx_msg LPUNKNOWN AddObject(LPCTSTR szObject, const VARIANT FAR& vVariableName, const VARIANT FAR& vLeft, const VARIANT FAR& vTop, const VARIANT FAR& vWidth, const VARIANT FAR& vHeight, const VARIANT FAR& vUnknown);
	afx_msg void bye();
	afx_msg void sleep(long milliseconds);
	afx_msg void UpdateScreen();
	afx_msg void Testomatic(long hWnd);
	afx_msg void SetMenu(LPCTSTR szID, const VARIANT FAR& vItems);
	afx_msg void chain(LPCTSTR szNewPath, const VARIANT FAR& vNewEnvironment);
	afx_msg void Break(const VARIANT FAR& ExecuteCode, const VARIANT FAR& Caption);
	afx_msg void KillFocus();
	afx_msg void WaitCursor(BOOL bWait);
	afx_msg short InputBox(LPCTSTR Prompt);
	afx_msg long ShellExecute(LPCTSTR verb, LPCTSTR file, const VARIANT FAR& parms);
	afx_msg long eval2(LPCTSTR szExpression, VARIANT *ret);
	afx_msg BOOL xPlaySound(LPCTSTR szSound, OLE_HANDLE hMod, long dwFlags);
	afx_msg void ShowOKButton(BOOL bShow);
	afx_msg long GetHWND(LPUNKNOWN obj);
	afx_msg BOOL xSetParent(LPUNKNOWN lpUnkC, LPUNKNOWN lpUnkP);
	afx_msg void DoEvents();
	afx_msg void doSendKey(short KeyState, short Char);
	afx_msg BOOL ShowFullScreen(long nFlags);
	afx_msg BOOL RunAppAtTime(LPCTSTR lpszApp, short yr, short mo, short dy, short hr, short mn, short sc);
	afx_msg BOOL RunAppAtEvent(LPCTSTR lpszApp, long nEvent);
	afx_msg BSTR GetCommandLine();
	afx_msg void DoDeclare(/*VARIANT FAR &var, */BSTR syntax);
	afx_msg BSTR GetSerialNumber();
	afx_msg BSTR SpecialFolder(long nFolder, const VARIANT FAR& fCreate);
	afx_msg long xSendMessage(long hwnd, long wMsg, long wParam, long lparam);
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
/////////////////////////////////////////////////////////////
// IActiveScriptSite interface
/////////////////////////////////////////////////////////////
	BEGIN_INTERFACE_PART(ActiveScriptSite, IActiveScriptSite)
		STDMETHOD(GetLCID)(LCID *plcid);
		STDMETHOD(GetItemInfo)(LPCOLESTR pstrName, DWORD dwReturnMask, IUnknown **ppunkItem, ITypeInfo **ppTypeInfo);
		STDMETHOD(GetDocVersionString)(BSTR *pbstrVersionString);
		STDMETHOD(OnScriptTerminate) (const struct tagVARIANT *,const struct tagEXCEPINFO *);
		STDMETHOD(OnStateChange)(SCRIPTSTATE ssScriptState);
		STDMETHOD(OnScriptError)(IActiveScriptError* pase);
		STDMETHOD(OnEnterScript)(void);
		STDMETHOD(OnLeaveScript)(void);
	END_INTERFACE_PART(ActiveScriptSite)

/////////////////////////////////////////////////////////////
// IActiveScriptSiteWindow interface
/////////////////////////////////////////////////////////////
	BEGIN_INTERFACE_PART(ActiveScriptSiteWindow, IActiveScriptSiteWindow)
		STDMETHOD(EnableModeless)(BOOL fEnable);
		STDMETHOD(GetWindow)(HWND *phwnd);
	END_INTERFACE_PART(ActiveScriptSiteWindow)

private:
	HWND m_hLastHWND;
	wchar_t *s;			// String for syntax to parse
	BSTR strToken;		// Token as a string
	TokenKind tokenType;
	int intToken;		// Token as an integer
} cScriptEngine;

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.



#endif // !defined(AFX_SCRIPTENGINE_H__6CA5B122_1609_11D2_852F_F26A3B000000__INCLUDED_)
